﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Helper
{
    public static class StringEx
    {
        /// <summary>
        /// 删除文件名非法字符
        /// </summary>
        public static string RemoveInvalidFile(string fileName)
        {
            if (fileName == null)
            { return null; }
            string name = fileName;
            name = name.Replace("&nbsp;", " ");
            name = name.Replace("\\", "");
            name = name.Replace("/", "");
            name = name.Replace("\"", "");
            name = name.Replace(":", "");
            name = name.Replace("?", "");
            name = name.Replace("*", "");
            name = name.Replace("<", "");
            name = name.Replace(">", "");
            name = name.Replace("|", "");
            name = name.Replace("\n", "");
            name = name.Replace("\t", "");
            name = name.Replace("\r", "");
            return name;
        }
        /// <summary>
        /// 读取JSON文件
        /// </summary>
        /// <param name="key">JSON文件中的key值</param>
        /// <returns>JSON文件中的value值</returns>
        public static string ExactJson(string json, string key)
        {
            try
            {
                JObject o = JObject.Parse(json);
                var value = o[key].ToString();
                return value;
            }
            catch (Exception)
            {
                return "未找到" + key;
            }

        }
        /// <summary>
        /// 是否base64字符串
        /// </summary>
        /// <param name="base64Str">要判断的字符串</param>
        /// <returns></returns>
        public static bool IsBase64String(string s)
        {
            s = s.Trim();
            return (s.Length % 4 == 0) && Regex.IsMatch(s, @"^[a-zA-Z0-9\+/]*={0,3}$", RegexOptions.None);
        }
        /// <summary>
        /// 取出中间字符串
        /// </summary>
        /// <param name="str">源字符串</param>
        /// <param name="left">左</param>
        /// <param name="right">右</param>
        /// <returns>成功返回结果,失败返回空</returns>
        public static string GetMiddleText(string str, string left, string right)
        {
            if (str == null || left == null || right == null) { return ""; }
            if (str == "" || left == "" || right == "") { return ""; }
            int a = str.IndexOf(left, 0);
            int b = str.IndexOf(right, a + 1);
            if (a < 0 || b < 0)
            { return ""; }
            else
            {
                a = a + left.Length;
                b = b - a;
                if (a < 0 || b < 0)
                { return ""; }
                return str.Substring(a, b);
            }
        }
        /// <summary>
        /// 取出右边字符串
        /// </summary>
        /// <param name="str">源字符串</param>
        /// <param name="left">左</param>
        /// <returns>成功返回结果,失败返回空</returns>
        public static string GetRightText(string str, string left)
        {
            if (str == "" || left == "") { return ""; }
            int a = str.IndexOf(left);
            if (a < 0)
            { return ""; }
            return str.Substring(a + left.Length);
        }
        /// <summary>
        /// 批量取出中间字符串
        /// </summary>
        /// <param name="source">源字符串</param>
        /// <param name="startStr">开始字符串</param>
        /// <param name="endStr">结束字符串</param>
        /// <returns>中间字符串</returns>
        public static string[] GetMiddleTextMultiple(string str, string left, string right)
        {
            if (str == null || left == null || right == null) { return null; }
            if (str == "" || left == "" || right == "") { return null; }
            Regex rg = new Regex("(?<=(" + left + "))[.\\s\\S]*?(?=(" + right + "))", RegexOptions.Multiline | RegexOptions.Singleline);
            MatchCollection matches = rg.Matches(str);
            List<string> resList = new List<string>();
            foreach (Match item in matches)
            { resList.Add(item.Value); }
            return resList.ToArray();
        }
        /// <summary>
        /// 获取两个字符串的相似度
        /// </summary>
        /// <param name=”sourceString”>第一个字符串</param>
        /// <param name=”str”>第二个字符串</param>
        /// <returns></returns>
        public static double GetSimilarityWith(string sourceString, string str)
        {
            double Kq = 2;
            double Kr = 1;
            double Ks = 1;
            char[] ss = sourceString.ToCharArray();
            char[] st = str.ToCharArray();
            //获取交集数量
            int q = ss.Intersect(st).Count();
            int s = ss.Length - q;
            int r = st.Length - q;
            return Kq * q / (Kq * q + Kr * r + Ks * s);
        }


        public static string[] ExactMultiple(string s, string rg)
        {
            List<string> result = new List<string>();
            Regex r = new Regex(rg, RegexOptions.Multiline | RegexOptions.Singleline);
            MatchCollection mc = r.Matches(s);
            for (int i = 0; i < mc.Count; i++)
            {
                result.Add(mc[i].Groups[1].Value);
            }
            return result.ToArray();
        }

        public static string Extract(string str, string regex)
        {
            Regex rg = new Regex(regex, RegexOptions.Multiline | RegexOptions.Singleline);
            MatchCollection col = rg.Matches(str);
            foreach (Match i in col)
            {
                return i.Groups[1].Value;
            }
            return "";
        }


    }
}
